# Import necessary Qiskit libraries
from qiskit import QuantumCircuit, transpile, assemble
from qiskit_aer import Aer, AerSimulator
from qiskit.visualization import plot_histogram
import matplotlib.pyplot as plt

# Step 1: Create a Quantum Circuit with 2 qubits and 2 classical bits
qc = QuantumCircuit(2, 2)

# Step 2: Apply a Hadamard gate to qubit 0 (superposition)
qc.h(0)

# Step 3: Apply a CNOT gate with qubit 0 as control and qubit 1 as target (entanglement)
qc.cx(0, 1)

# Step 4: Measure the qubits and store the results in classical bits
qc.measure([0, 1], [0, 1])

# Step 5:For execution
simulator = AerSimulator()
compiled_circuit = transpile(qc, simulator)
sim_result = simulator.run(compiled_circuit).result()
counts = sim_result.get_counts()

print(qc)

qc.draw(output='mpl')
plt.show()

# Step 6: Get and display the result as a histogram
print("Result:", counts)
plot_histogram(counts)
plt.show()