from qiskit import QuantumCircuit, transpile, assemble
from qiskit_ibm_runtime import QiskitRuntimeService, SamplerV2 as Sampler
from qiskit.visualization import plot_histogram

# Step 1: Initialize the Qiskit Runtime Service with the token
service = QiskitRuntimeService(channel="ibm_quantum", token="67eb717a36a256370955f3a56e56666a6500be6b06b2c079e781958051c5a1038cc6e1b3fa8a38c5bca5f7bfb3da83e332002a107d4e37017124e36ebbced111")
# Step 2: Create a simple quantum circuit
qc = QuantumCircuit(2, 2)
qc.measure([0, 1], [0, 1])  # Measure both qubits

backend = service.least_busy(operational=True, simulator=False)
 
sampler = Sampler(backend)
job = sampler.run([qc])
print(f"job id: {job.job_id()}")
result = job.result()
print(result)