from qiskit import QuantumCircuit, transpile, assemble
from qiskit_ibm_runtime import QiskitRuntimeService, SamplerV2 as Sampler
from qiskit.visualization import plot_histogram

# Step 1: Initialize the Qiskit Runtime Service with the token
service = QiskitRuntimeService(channel="ibm_quantum", token="67eb717a36a256370955f3a56e56666a6500be6b06b2c079e781958051c5a1038cc6e1b3fa8a38c5bca5f7bfb3da83e332002a107d4e37017124e36ebbced111")
# Create a Quantum Circuit with 2 qubits and 2 classical bits
qc = QuantumCircuit(2, 2)

# Add gates to the circuit
qc.h(0)  # Apply Hadamard gate to the first qubit
qc.cx(0, 1)  # Apply CNOT gate with qubit 0 as control and qubit 1 as target

# Measure the qubits
qc.measure([0, 1], [0, 1])

backend = service.least_busy(operational=True, simulator=False)

# Transpile the circuit for the target backend
transpiled_circuit = transpile(qc, backend)
print("\nTranspiled Circuit:")
print(transpiled_circuit)

sampler = Sampler(backend)
job = sampler.run([transpiled_circuit])
print(f"job id: {job.job_id()}")
result = job.result()
print(result)

